﻿function getParameterByName(name, defaultValue) {
    name = name.replace(/[\[]/, "\\\[").replace(/[\]]/, "\\\]");
    var regexS = "[\\?&]" + name + "=([^&#]*)";
    var regex = new RegExp(regexS);
    var results = regex.exec(window.location.href);
    if (results === null)
        return defaultValue;
    else
        return decodeURIComponent(results[1].replace(/\+/g, " "));
}

Date.prototype.toLocaleDateString = function () {
    if (navigator.language == "en-US" || navigator.language == "en-CA") {
        return (this.getMonth() + 1) + "/" + this.getDate() + "/" + this.getFullYear()
    }
    return this.getDate() + "/" + (this.getMonth() + 1) + "/" + this.getFullYear()
};

function checkSession() {
    $.ajax({
        url: 'service?method=session.valid&format=json',
        type: 'GET',        
        contentType: 'application/json',
        success: function (data) {            
            console.log(data);
            if (data.stat != "ok") {
                var seconds = Math.round(new Date().getTime() / 1000);
                var url = new URL(window.location.href);
                url.searchParams.set('t', seconds);                
                console.log("session is not active");
                window.location.href = url;
            }
        },
        error: function (error) {
            console.log("failed checking session. server running?");
        }
    });
}

function promptForEPGUpdate() {
    var messageModal = app.__vue__.$refs.messageModal;
    messageModal.showMessage("Update EPG", "Your channel lineup has changed. Would you like to update your EPG now?", "Update EPG", "Not now");
}

function showMessageCallback(button) {
    if (button == "Update EPG") {
        var modal = app.__vue__.$refs.updateEPGModal;
        modal.updateEPG();
    }
}

function lightOrDark(color) {

    // Variables for red, green, blue values
    var r, g, b, hsp;

    // Check the format of the color, HEX or RGB?
    if (color.match(/^rgb/)) {

        // If HEX --> store the red, green, blue values in separate variables
        color = color.match(/^rgba?\((\d+),\s*(\d+),\s*(\d+)(?:,\s*(\d+(?:\.\d+)?))?\)$/);

        r = color[1];
        g = color[2];
        b = color[3];
    }
    else {

        color = +("0x" + color.slice(1).replace(
            color.length < 5 && /./g, '$&$&'));

        r = color >> 16;
        g = color >> 8 & 255;
        b = color & 255;
    }

    // HSP (Highly Sensitive Poo) equation from http://alienryderflex.com/hsp.html
    hsp = Math.sqrt(
        0.299 * (r * r) +
        0.587 * (g * g) +
        0.114 * (b * b)
    );

    // Using the HSP value, determine whether the color is light or dark
    if (hsp > 127.5) {

        return 'light';
    }
    else {

        return 'dark';
    }
}
