﻿var fakedID = -1;

// load the tv listings for the specified channel
function loadListingsForChannel(channel, scrollLeft) {
    // we wont need to process this channel again
    channel.loaded = true;    

    var currentTime = (new Date()).getTime() / 1000;

    // grab listings for this channel
    var startDate = selectedDate;
    startDate.setHours(0, 0, 0, 0); // last midnight
    var startTime = startDate.getTime() / 1000;
    var endTime = startTime + 86400;
    var listingURL = 'services/service?method=channel.listings&channel_id=' + channel.channelId + "&start=" + startTime + "&end=" + endTime + '&colors=true&format=json&random=' + Math.random();
    $.getJSON(listingURL, function (response) {
        console.log("got listings");

        $("#channelListings-" + channel.channelId).empty();

        // if we've got no listings for this channel, add some placeholders so the guide isn't empty
        if (response.listings.length == 0) {
            console.log("no listings");
            var fakeStart = 0;
            for (fakeStart = startTime; fakeStart < endTime; fakeStart += 1800) {
                var listing = { "id": fakedID, "name": "(no listings)", "description": "No listings available for the specified time", "start": fakeStart, "end": (fakeStart + 1800) };
                response.listings.push(listing)
                fakedID--;
            }
        }

        // add each listing
        var listingsHTML = "";
        var max_e = 0;
        for (i = 0; i < response.listings.length; i++) {
            var listing = response.listings[i];


            listing.channelId = channel.channelId;

            var s = Math.round((listing.start - startTime) / 60);
            if (s < 0)
                s = 0;

            var e = Math.round((listing.end - startTime) / 60);
            if (e > (60 * 60))
                e = (60 * 60);

            if (e > max_e)
                max_e = e;

            var cssClass = "";
            var currentEvent = false;

            var extra = "";

            if (e > s) {
                var w = ((e - s) * 6);
                var o = (s * 6);

                var paddingExtra = "";                


                if (listing.start < currentTime && listing.end > currentTime) {
                    currentEvent = true;                    
                    
                    // work around to ensure current show names are visible
                    if (o < scrollLeft && (o + w) > scrollLeft) {
                        console.log("cropped " + listing.name);
                        var cut = (scrollLeft - o);
                        if (cut > 0) {                            
                            var padding = cut;
                            paddingExtra = "padding-left: " + padding + "px;"
                            channel.relocated = listing;
                        }
                    }
                }
                var classes = 'bg-light no-select text-dark guide-listing';

                if (currentEvent) {
                    classes += ' guide-listing-airing-now';
                    currentShowLookup[channel.channelId] = listing;
                }      

                if (showGenreColors && listing.hasOwnProperty('color')) {
                    classes += ' ' + listing.color;
                }

                if (typeof listing.recording_id !== "undefined") {
                    switch (listing.recording_status) {
                        case "pending":
                            classes += " guide-listing-scheduled";
                            break;
                        case "recording":
                            classes += " guide-listing-recording";
                            break;
                        case "ready":
                            classes += " guide-listing-ready";
                            break;
                        case "failed":
                            classes += " guide-listing-failed";
                            break;
                        case "conflict":
                            classes += " guide-listing-conflict";
                            break;                                                    
                    }
                }

                if (typeof listing.significance !== "undefined") {
                    if (listing.significance == "Season Premiere") {
                        classes += ' season-premiere';
                    }
                    else if (listing.significance == "Season Finale") {
                        classes += ' season-finale';
                    }
                    else if (listing.significance == "Series Premiere") {
                        classes += ' series-premiere';
                    }
                    else if (listing.significance == "Series Finale") {
                        classes += ' series-finale';
                    }
                    else if (listing.significance == "Live") {
                        classes += ' airing-live';
                    }
                }
                else if (listing.firstrun === true && showNewInGuide) {
                    classes += ' new-show';
                }


                cssClass = 'class="' + classes + '"';

            }   

            listingsHTML += '<div id="listing-' + listing.id + '"' + cssClass + ' style="position: absolute; left: ' + o + 'px; width: ' + w + 'px; ' + paddingExtra + '" >' + listing.name + '</div>';

            // cache for later lookups
            listingLookup[listing.id] = listing;
        }

        $("#channelListings-" + channel.channelId).append(listingsHTML);
    });
}