﻿window.onload = function () {
    var app = new Vue({
        el: '#app',
        data: {
        }
    });
};

Vue.component('user_grid', {
    data: function () {
        return {
            items: []
        }
    },    
    template: '<div id="userGrid" >\
                    <div class="row">\
                        <div v-for="(item, index) in items" class="row-no-padding">\
                            <div id="channel" @click="trigger({ index })" class="user-item">\
                                <div class="text-dark text-center pad-top"><i class="fas fa-user fa-4x"></i></div>\
                                <div class="float-right channel-icon-container"><img src="service?method=channel.icon&amp;channel_id=25172" class="channel-icon"><i class="fas fa-trash"></i></div>\
                                <div class="caption-btm text-center pad-top">{{ item.name }}</div>\
                            </div>\
                        </div>\
                    </div>\
                </div>',
    mounted: function () {
        var self = this;
        var url = 'services/service?method=system.users';
        
        $.getJSON(url, function (users) {

            // populate list
            self.items = users;            
            
        });
    },
    methods: {
        trigger(args) {
            var user = this.items[args.index];            
            console.log(user.name);
            if (window.eventBus != null) {
                window.eventBus.$emit('editUser', user);
            }
        }
    }
});
