﻿window.onload = function () {
    var app = new Vue({
        el: '#app',
        data: {
        }
    });
};

Vue.component('update_epg_modal', {
    data: function () {
        return {
            listing: "",
            timer: 0
        };
    },
    template: '<div class="modal fade" id="updateEPGModal" tabindex="-1" role="dialog" aria-labelledby="updateEPGModalLabel" aria-hidden="true">\
                    <div class= "modal-dialog modal-lg" role="document" >\
                        <div class="modal-content">\
                            <div class="modal-header">\
                                <h5 class="modal-title" id="updateEPGModalTitle">Update EPG</h5>\
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">\
                                    <span aria-hidden="true">&times;</span>\
                                </button>\
                            </div>\
                            <div class="modal-body">\
                                <p id="updateEPGStatus">Starting EPG update...</p>\
                            </div>\
                            <div class= "modal-footer">\
                                <small><p id="updateEPGStatus" class="text-muted">You can safely close this popup or page, and the EPG update will continue in the background. You can click Update EPG again later to return to this popup and continue to monitor the progress.</p></small>\
                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>\
                            </div>\
                        </div>\
                    </div>\
               </div>',
    mounted: function () {
        var self = this;
        self.loaded = false;
    },
    methods: {
        updateEPG() {
            var self = this;

            if (self.timer !== 0) {
                clearInterval(self.timer);
                self.timer = 0;
            }

            console.log("initiating EPG update...");
            $('#updateEPGStatus').text("Initiating EPG updates...");
            $('#updateEPGModal').modal('show');

            var url = 'services/service?method=system.epg.update&format=json';
            $.getJSON(url, function (data) {
                if (data.stat === "ok") {
                    $('#updateEPGStatus').text("Starting EPG update");
                    //self.items = data.status;

                    self.timer = setInterval(self.checkEPGUpdateStatus, 1000);
                } else {
                    alert("Unable to Update EPG at this time");
                }
            });

        },
        checkEPGUpdateStatus() {
            console.log("checking...");
            var self = this;
            var url = 'services/service?method=system.epg.status&format=json';

            $.ajax({
                url: url,                
                type: 'get',
                async: true,
                success: function (data, textStatus, xhr) {
                    if (data.stat === "ok") {
                        $('#updateEPGStatus').text(data.status);
                    }

                    if (data.updating === false) {
                        clearInterval(self.timer);
                        self.timer = 0;
                    }
                },
                error: function (xhr, textStatus, errorThrown) {
                    console.log("Unexpected error checking EPG update status");
                    $('#updateEPGStatus').text("Lost contact with NextPVR backend");
                    clearInterval(self.timer);
                    self.timer = 0;
                }
            });
        }
    }
});
