﻿window.onload = function () {
    var app = new Vue({
        el: '#app',
        data: {
        }
    });
};

Vue.component('show_message_modal', {
    data: function () {
        return {
            listing: "",
            timer: 0
        };
    },
    template: '<div class="modal fade" id="messageModal" tabindex="-1" role="dialog" aria-labelledby="messageModalLabel" aria-hidden="true">\
                    <div class= "modal-dialog modal-lg" role="document" >\
                        <div class="modal-content">\
                            <div class="modal-header">\
                                <h5 class="modal-title" id="messageModalTitle"></h5>\
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">\
                                    <span aria-hidden="true">&times;</span>\
                                </button>\
                            </div>\
                            <div class="modal-body">\
                                <p id="messageBody"></p>\
                            </div>\
                            <div class= "modal-footer">\
                                <button id="updateEPGButton1" type="button" class="btn btn-primary d-none" data-dismiss="modal">OK</button>\
                                <button id="updateEPGButton2" type="button" class="btn btn-secondary" data-dismiss="modal">OK</button>\
                            </div>\
                        </div>\
                    </div>\
               </div>',
    mounted: function () {
        var self = this;
        self.loaded = false;
    },
    methods: {
        showMessage(title, body, button1, button2) {
            var self = this;

            $('#messageModalTitle').text(title);
            $('#messageBody').text(body);
            
            if (button1 != undefined && button2 != undefined) {
                $('#updateEPGButton1').text(button1);
                $('#updateEPGButton1').removeClass("d-none");
                $('#updateEPGButton1').on('click', function () {
                    showMessageCallback($('#updateEPGButton1').text());
                });

                $('#updateEPGButton2').text(button2);
                $('#updateEPGButton2').on('click', function () {
                    showMessageCallback($('#updateEPGButton2').text());
                });
            }
            else if (button1 != undefined) {
                $('#updateEPGButton2').text(button1);

                $('#updateEPGButton2').on('click', function () {
                    showMessageCallback($('#updateEPGButton2').text());
                });
            }

            $('#messageModal').modal('show');
        }
    }
});