﻿window.onload = function () {
    var app = new Vue({
        el: '#app',
        data: {
        }
    });
};

Vue.component('select_frequency_list', {
    data: function () {
        return {
            items: []
        }
    },
    props: ['recurring'],

    template: '<div id="selectFrequencyList" >\
                    <div v-if="items.length > 0">\
                        <table class="table table_condensed table-bordered table-responsive-md table-striped text-center">\
                            <tr>\
                                <th class="text-left td-condensed" width="5%"><input id="selectAllCheckbox" type="checkbox" class="big-checkbox" checked @click="toggleSelectAll"></th>\
                                <th class="text-left td-condensed" width="50%">EPG Frequency</th>\
                                <th class="text-left td-condensed" width="20%"></th>\
                                <th class="text-left td-condensed" width="25%"></th>\
                            </tr>\
                            <tr v-for="(item, index) in items" >\
                                <td class="text-left td-condensed"><input type="checkbox" class="big-checkbox"  v-model="item.checked"/></td>\
                                <td class="text-left td-condensed">{{ item.name }}</td>\
                                <td class="text-left td-condensed"></td>\
                                <td class="text-left td-condensed"></td>\
                            </tr>\
                        </table>\
                    </div>\
                </div>',
    mounted: function () {
        var self = this;     

        var url = 'service?method=setting.dvb.frequencies&format=json';
        $.getJSON(url, function (frequencies) {
            self.items = frequencies;
        });
    },
    methods: {
        toggleSelectAll() {
            var self = this;              
            if ($("#selectAllCheckbox").is(':checked')) {                
                // select all frequencies
                self.items.forEach(function (frequency) {
                    frequency.checked = true;
                });
            } else {
                // deselect all frequencies
                self.items.forEach(function (frequency) {
                    frequency.checked = false;
                });
            }
        },
        getSelectedChannels() {
            var self = this;     
            var selectedChannels = [];
            self.items.forEach(function (channel) {
                if (channel.selected) {
                    selectedChannels.push(channel);
                }
            });
            return selectedChannels;
        }
    }
});
