﻿window.onload = function () {
    var app = new Vue({
        el: '#app',
        data: {
        }
    });
};

Vue.component('select_channels_list', {
    data: function () {
        return {
            items: []
        }
    },
    props: ['recurring'],

    template: '<div id="selectChannelList" >\
                    <div v-if="items.length > 0">\
                        <table class="table table_condensed table-bordered table-responsive-md table-striped text-center">\
                            <tr>\
                                <th class="text-left td-condensed" width="5%"><input id="selectAllCheckbox" type="checkbox" class="big-checkbox" checked @click="toggleSelectAll"></th>\
                                <th class="text-left td-condensed" width="10%">Number</th>\
                                <th class="text-left td-condensed" width="40%">Name</th>\
                                <th class="text-left td-condensed" width="45%">Details</th>\
                            </tr>\
                            <tr v-for="(item, index) in items" >\
                                <td class="text-left td-condensed"><input type="checkbox" class="big-checkbox"  v-model="item.selected"/></td>\
                                <td class="text-left td-condensed">{{ item.channelNumberFormated }}</td>\
                                <td class="text-left td-condensed">{{ item.channelName }}</td>\
                                <td class="text-left td-condensed">{{ item.channelDetails }}</td>\
                            </tr>\
                        </table>\
                    </div>\
                </div>',
    mounted: function () {
        var self = this;     
    },
    methods: {
        showChannels(channels) {
            var self = this;          
            channels.forEach(function (channel) {
                if (channel.channelEncrypted)
                    channel.selected = false;
                else
                    channel.selected = true;
            });
            self.items = channels;                
        },
        toggleSelectAll() {
            var self = this;              
            if ($("#selectAllCheckbox").is(':checked')) {                
                // select all channels
                self.items.forEach(function (channel) {
                    channel.selected = true;
                });
            } else {
                // deselect all channels                
                self.items.forEach(function (channel) {
                    channel.selected = false;
                });
            }
        },
        getSelectedChannels() {
            var self = this;     
            var selectedChannels = [];
            self.items.forEach(function (channel) {
                if (channel.selected) {
                    selectedChannels.push(channel);
                }
            });
            return selectedChannels;
        }
    }
});
