﻿window.onload = function () {
    var app = new Vue({
        el: '#app',
        data: {
        }
    });
};

Vue.component('recurrings_grid', {
    data: function () {        
        return {
            listItems: []
        }
    },

    template: '<div id="recurringsList" >\
                    <div>\
                        <div v-for="(item, index) in listItems" class="col-12 row-no-padding">\
                            <div id="recording" class="recording-list-item bg-light" @click="editRecurring({ index })">\
                                <div class="row" @click="trigger({ index })">\
                                    <div class="col-8">\
                                        <span class="text-primary">{{ item.name }}</span>\
                                    </div>\
                                    <div class="col-4">\
                                    </div>\
                                </div>\
                                <div class="row">\
                                    <div class="col-11" @click="trigger({ index })">\
                                        <span class="text-dark">{{ item.channel }} :</span>&nbsp;\
                                        <span class="text-secondary"> \
                                            {{ item.period }}\
                                        </span>\
                                    </div>\
                                    <div class="col-1 ">\
                                        <div class="text-center float-right" @click.stop="deleteRecurring({ index })"><i class="fa fa-trash fa-lg text-secondary"></i></div><br>\
                                    </div>\
                                </div>\
                            </div>\
                        </div>\
                    </div>\
                </div>',

    mounted: function () {
        var self = this;
        self.reload(self.list);
    },
    computed: {
    },
    methods: {
        trigger(args) {
        },
        deleteRecurring(args) {
            var recurring = this.listItems[args.index];
            var self = this;
            var url = 'services/service?method=recording.recurring.delete&recurring_id=' + recurring.id;
            $.getJSON(url, function (data) {
                self.reload();
                if (window.eventBus != null) {
                    window.eventBus.$emit('reloadRecordings', recurring);
                }
            });
        },
        editRecurring(args) {
            var recurring = this.listItems[args.index];
            if (window.eventBus != null) {
                window.eventBus.$emit('editRecurring', recurring);
            }
        },
        editRecurringParent(pending) {
            this.listItems.forEach(function (recurring) {
                if (recurring.id == pending.recurringParent) {
                    if (window.eventBus != null) {
                        window.eventBus.$emit('editRecurring', recurring);
                    }
                }
            });
        },
        reload() {
            var self = this;
            var url = 'services/service?method=recording.recurring.list';
            $.getJSON(url, function (data) {
                console.log("got recurrings");
                self.listItems = data.recurrings;
            });
        }
    }
});
