﻿window.onload = function () {
    var app = new Vue({
        el: '#app',
        data: {
        }
    });
};

Vue.component('manual_record_modal', {
    data: function () {
        return {
            listing: "",
            existingRecurring: null,
            existingRecording: null,
            channels: null
        };
    },
    template: '<div class="modal fade" id="manualRecordModal" tabindex="-1" role="dialog" aria-labelledby="manualRecordModalLabel" aria-hidden="true">\
                    <div class= "modal-dialog modal-lg" role="document" >\
                        <div class="modal-content">\
                            <div class="modal-header">\
                                <h5 class="modal-title" id="manualRecordModalTitle">Modal title</h5>\
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">\
                                    <span aria-hidden="true">&times;</span>\
                                </button>\
                            </div>\
                            <div class="modal-body">\
                                <div class="row">\
                                    <div class="col-12">\
                                        <p id="manualRecordModalPeriod" class="text-light"></p>\
                                    </div>\
                                </div>\
                                <div class="row">\
                                    <div class="form-inline col-12">\
                                        <div class="col-12 form-group extra-vertical">\
                                            <label class="col-lg-3 col-sm-5 col-form-label font-weight-bold" for="manualName">Recording Name:</label>\
                                            <input id="manualName" type="text" value="default" class="form-control col-lg-6 col-sm-7" data-container="body"></input>\
                                        </div>\
                                    </div>\
                                    <div class="form-inline col-12">\
                                        <div class="col-12 form-group extra-vertical">\
                                            <label class="col-lg-3 col-sm-5 col-form-label font-weight-bold" for="name">Recording Type:</label>\
                                            <select id="manualType" class="custom-select col-lg-6 col-sm-7" data-container="body" @change="onTypeChange($event)">\
                                                <option value="once">Record Once</option>\
                                                <option value="3">Record Daily</option>\
                                                <option value="4">Record Weekly</option>\
                                                <option value="5">Record Week Days (Monday-Friday)</option>\
                                                <option value="6">Record Weekends (Saturday/Sunday)</option>\
                                                <option value="keyword">Keyword</option>\
                                                <option value="advanced">Advanced</option>\
                                            </select>\
                                        </div>\
                                    </div>\
                                    <div class="form-inline col-12">\
                                        <div class="col-12 form-group extra-vertical">\
                                            <label class="col-lg-3 col-sm-5 col-form-label font-weight-bold" for="advancedChannelSelector">Channel:</label>\
                                            <select id="manualChannelSelector" class="custom-select col-lg-6 col-sm-7" data-container="body">\
                                            </select>\
                                        </div>\
                                    </div>\
                                    <div class="form-inline col-12 manualKeywordSettings">\
                                        <div class="col-12 form-group extra-vertical">\
                                            <label class="col-lg-3 col-sm-5 col-form-label font-weight-bold" for="name">Keyword Type:</label>\
                                            <select id="manualKeywordType" class="custom-select col-lg-6 col-sm-7" data-container="body">\
                                                <option value="title">Title</option>\
                                                <option value="description">Title or Description</option>\
                                                <option value="cast">Cast or Crew</option>\
                                            </select>\
                                        </div>\
                                    </div>\
                                    <div class="form-inline col-12 manualKeywordSettings">\
                                        <div class="col-12 form-group extra-vertical">\
                                            <label class="col-lg-3 col-sm-5 col-form-label font-weight-bold" for="manualName">Keyword:</label>\
                                            <input id="manualKeyword" type="text" value="" class="form-control col-lg-6 col-sm-7" data-container="body"></input>\
                                        </div>\
                                    </div>\
                                    <div class="form-inline col-12 manualTimeDurationSettings">\
                                        <div class="col-12 form-group extra-vertical">\
                                            <label class="col-lg-3 col-sm-5 col-form-label font-weight-bold" for="name">Date / Time:</label>\
                                            <!--<input type="text" class="form-control datetimepicker-input col-lg-6 col-sm-7" id="manualDateTime" data-toggle="datetimepicker" data-target="#manualDateTime" />-->\
                                            <div class="input-group date col-lg-6 col-sm-7 no-padding" id="manualDateTime" data-target-input="nearest">\
                                                <input type="text" class="form-control datetimepicker-input" data-target="#manualDateTime"/>\
                                                <div class="input-group-append" data-target="#manualDateTime" data-toggle="datetimepicker">\
                                                    <div class="input-group-text"><i class="fa fa-calendar"></i></div>\
                                                </div>\
                                            </div>\
                                        </div>\
                                    </div>\
                                    <div class="form-inline col-12 manualTimeDurationSettings">\
                                        <div class="col-12 form-group extra-vertical">\
                                            <label class="col-lg-3 col-sm-5 col-form-label font-weight-bold" for="name">Duration (mins):</label>\
                                            <input id="manualDuration" type="number" class="form-control col-lg-6 col-sm-7" min="0" max="600"/>\
                                        </div>\
                                    </div>\
                                    <div class="form-inline col-12 manualAdvancedSettings">\
                                        <div class="col-12 form-group extra-vertical">\
                                            <label class="col-lg-3 col-sm-5 col-form-label font-weight-bold" for="manualName">Advanced:</label>\
                                           <input id="manualAdvanced" type="text" value="" class="form-control col-lg-6 col-sm-7" data-container="body"></input>\
                                        </div>\
                                    </div>\
                                    <div class="form-inline col-12">\
                                        <div class="col-12 form-group extra-vertical">\
                                            <label class="col-lg-3 col-sm-5 col-form-label font-weight-bold" for="name">Pre-Padding:</label>\
                                            <select id="manualPrePadding" class="custom-select col-lg-6 col-sm-7" data-container="body">\
                                                <option value="default">Default</option>\
                                                <option value="0">0</option>\
                                                <option value="1">1</option>\
                                                <option value="2">2</option>\
                                                <option value="3">3</option>\
                                                <option value="4">4</option>\
                                                <option value="5">5</option>\
                                                <option value="6">6</option>\
                                                <option value="7">7</option>\
                                                <option value="8">8</option>\
                                                <option value="9">9</option>\
                                                <option value="10">10</option>\
                                                <option value="11">11</option>\
                                                <option value="12">12</option>\
                                                <option value="13">13</option>\
                                                <option value="14">14</option>\
                                                <option value="15">15</option>\
                                                <option value="16">16</option>\
                                                <option value="17">17</option>\
                                                <option value="18">18</option>\
                                                <option value="19">19</option>\
                                                <option value="20">20</option>\
                                                <option value="21">21</option>\
                                                <option value="22">22</option>\
                                                <option value="23">23</option>\
                                                <option value="24">24</option>\
                                                <option value="25">25</option>\
                                                <option value="26">26</option>\
                                                <option value="27">27</option>\
                                                <option value="28">28</option>\
                                                <option value="29">29</option>\
                                                <option value="30">30</option>\
                                                <option value="31">31</option>\
                                                <option value="32">32</option>\
                                                <option value="33">33</option>\
                                                <option value="34">34</option>\
                                                <option value="35">35</option>\
                                                <option value="36">36</option>\
                                                <option value="37">37</option>\
                                                <option value="38">38</option>\
                                                <option value="39">39</option>\
                                                <option value="40">40</option>\
                                                <option value="41">41</option>\
                                                <option value="42">42</option>\
                                                <option value="43">43</option>\
                                                <option value="44">44</option>\
                                                <option value="45">45</option>\
                                                <option value="46">46</option>\
                                                <option value="47">47</option>\
                                                <option value="48">48</option>\
                                                <option value="49">49</option>\
                                                <option value="50">50</option>\
                                                <option value="51">51</option>\
                                                <option value="52">52</option>\
                                                <option value="53">53</option>\
                                                <option value="54">54</option>\
                                                <option value="55">55</option>\
                                                <option value="56">56</option>\
                                                <option value="57">57</option>\
                                                <option value="58">58</option>\
                                                <option value="59">59</option>\
                                                <option value="60">60</option>\
                                            </select>\
                                        </div>\
                                    </div>\
                                    <div class="form-inline col-12">\
                                        <div class="col-12 form-group extra-vertical">\
                                            <label class="col-lg-3 col-sm-5 col-form-label font-weight-bold" for="name">Post-Padding:</label>\
                                            <select id="manualPostPadding" class="custom-select col-lg-6 col-sm-7" data-container="body">\
                                                <option value="default">Default</option>\
                                                <option value="0">0</option>\
                                                <option value="1">1</option>\
                                                <option value="2">2</option>\
                                                <option value="3">3</option>\
                                                <option value="4">4</option>\
                                                <option value="5">5</option>\
                                                <option value="6">6</option>\
                                                <option value="7">7</option>\
                                                <option value="8">8</option>\
                                                <option value="9">9</option>\
                                                <option value="10">10</option>\
                                                <option value="11">11</option>\
                                                <option value="12">12</option>\
                                                <option value="13">13</option>\
                                                <option value="14">14</option>\
                                                <option value="15">15</option>\
                                                <option value="16">16</option>\
                                                <option value="17">17</option>\
                                                <option value="18">18</option>\
                                                <option value="19">19</option>\
                                                <option value="20">20</option>\
                                                <option value="21">21</option>\
                                                <option value="22">22</option>\
                                                <option value="23">23</option>\
                                                <option value="24">24</option>\
                                                <option value="25">25</option>\
                                                <option value="26">26</option>\
                                                <option value="27">27</option>\
                                                <option value="28">28</option>\
                                                <option value="29">29</option>\
                                                <option value="30">30</option>\
                                                <option value="31">31</option>\
                                                <option value="32">32</option>\
                                                <option value="33">33</option>\
                                                <option value="34">34</option>\
                                                <option value="35">35</option>\
                                                <option value="36">36</option>\
                                                <option value="37">37</option>\
                                                <option value="38">38</option>\
                                                <option value="39">39</option>\
                                                <option value="40">40</option>\
                                                <option value="41">41</option>\
                                                <option value="42">42</option>\
                                                <option value="43">43</option>\
                                                <option value="44">44</option>\
                                                <option value="45">45</option>\
                                                <option value="46">46</option>\
                                                <option value="47">47</option>\
                                                <option value="48">48</option>\
                                                <option value="49">49</option>\
                                                <option value="50">50</option>\
                                                <option value="51">51</option>\
                                                <option value="52">52</option>\
                                                <option value="53">53</option>\
                                                <option value="54">54</option>\
                                                <option value="55">55</option>\
                                                <option value="56">56</option>\
                                                <option value="57">57</option>\
                                                <option value="58">58</option>\
                                                <option value="59">59</option>\
                                                <option value="60">60</option>\
                                            </select>\
                                        </div>\
                                    </div>\
                                    <div class="form-inline col-12">\
                                        <div class="col-12 form-group extra-vertical">\
                                            <label class="col-lg-3 col-sm-5 col-form-label font-weight-bold" for="name">Directory:</label>\
                                            <select id="manualDirectory" class="custom-select col-lg-6 col-sm-7" data-container="body">\
                                                <option value="default">Default</option>\
                                            </select>\
                                        </div>\
                                    </div>\
                                    <div class="form-inline col-12">\
                                        <div class="col-12 form-group extra-vertical">\
                                            <label class="col-lg-3 col-sm-5 col-form-label font-weight-bold" for="name">Keep:</label>\
                                            <select id="manualKeep" class="custom-select col-lg-6 col-sm-7" data-container="body">\
                                                <option value="0">All</option>\
                                                <option value="1">1</option>\
                                                <option value="2">2</option>\
                                                <option value="3">3</option>\
                                                <option value="4">4</option>\
                                                <option value="5">5</option>\
                                                <option value="6">6</option>\
                                                <option value="7">7</option>\
                                                <option value="8">8</option>\
                                                <option value="9">9</option>\
                                                <option value="10">10</option>\
                                                <option value="11">11</option>\
                                                <option value="12">12</option>\
                                                <option value="13">13</option>\
                                                <option value="14">14</option>\
                                                <option value="15">15</option>\
                                                <option value="16">16</option>\
                                                <option value="17">17</option>\
                                                <option value="18">18</option>\
                                                <option value="19">19</option>\
                                                <option value="20">20</option>\
                                            </select>\
                                        </div>\
                                    </div>\
                                </div>\
                            </div>\
                            <div class="modal-footer">\
                                <button type="button" class="btn btn-danger" @click="save()" data-dismiss="modal">Save</button>\
                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>\
                            </div>\
                        </div>\
                    </div>\
               </div>',
    mounted: function () {
        var self = this;
        self.loaded = false;

        // add directories
        var url = 'services/service?method=setting.list';
        $.getJSON(url, function (data) {
            self.directories = data.recordingDirectories.split(",");

            $('#manualDirectory').empty();
            self.directories.forEach(function (directory) {
                $('#manualDirectory').append("<option value='" + directory + "'>" + directory + "</option>");
            });
        });
    },
    methods: {
        show(advancedQuery) {
            var self = this;
            //this.listing = listing;
            this.existingRecurring = null;
            this.existingRecording = null;

            var currentTime = (new Date()).getTime() / 1000;

            $('#manualRecordModalTitle').text("Add Manual Recording");

            // populate pre padding options
            $('#manualPrePadding').empty();
            $('#manualPrePadding').append("<option value='default'>Default</option>");
            for (i = 0; i <= 120; i++) {
                $('#manualPrePadding').append("<option value='" + i + "'>" + i + "</option>");
            }

            // populate post padding options
            $('#manualPostPadding').empty();
            $('#manualPostPadding').append("<option value='default'>Default</option>");
            for (i = 0; i <= 120; i++) {
                $('#manualPostPadding').append("<option value='" + i + "'>" + i + "</option>");
            }

            $('#manualType').val('once');
            $('#manualDuration').val('60');
            $('#manualPrePadding').val('default');
            $('#manualPostPadding').val('default');
            $('#manualKeep').val('0');
            $('#manualDirectory').val('Default');

            $('.manualKeywordSettings').hide();
            $('.manualAdvancedSettings').hide();
            $('.manualTimeDurationSettings').show();



            // set date format, and a default date/time of (8:30pm)
            var defaultDateTime = new Date();
            defaultDateTime.setHours(20, 30, 0, 0);
            if (defaultDateTime < Date()) {
                defaultDateTime.setDate(d.getDate(), 1);
            }
            var minDate = new Date();
            $('#manualDateTime').datetimepicker({
                format: 'YYYY-MM-DD HH:mm',
                date: defaultDateTime,
                minDate: minDate,
                sideBySide: true
            });


            // load channel list
            $('#manualChannelSelector').empty();
            var url = 'services/service?method=channel.list';
            var preferredChannelGroup = localStorage.getItem('preferredChannelGroup');
            if (preferredChannelGroup !== null) {
                url += "&group_id=" + encodeURIComponent(preferredChannelGroup);
            }
            $('#manualChannelSelector').append('<option id="manualAnyChannel" value="0">[Any Channel]</option>');
            $('#manualAnyChannel').hide();
            $.getJSON(url, function (data) {
                self.channels = data.channels;
                // default to empty current show name
                data.channels.forEach(function (channel) {
                    $('#manualChannelSelector').append('<option value="' + channel.channelId + '">' + channel.channelName + '</option>');
                });
                var defaultChannel = data.channels[0].channelId;

                if (typeof (advancedQuery) != "undefined") {
                    defaultChannel = "0";
                }

                $('#manualChannelSelector').val(defaultChannel);
                $('#manualChannelSelector').val(defaultChannel).trigger("change");


            });


            // were we passed an advanced record query?
            if (typeof (advancedQuery) != "undefined") {
                $('#manualType').val('advanced');
                self.onTypeChange(null);
                $('#manualChannelSelector').val("0");
                $('#manualChannelSelector').val("0").trigger("change");


                $('#manualAdvanced').val(advancedQuery);

                $('.manualKeywordSettings').hide();
                $('.manualTimeDurationSettings').hide();
                $('.manualAdvancedSettings').show();

                $('#manualAnyChannel').show();
                $('#manualChannelSelector').val("0");
                $('#manualChannelSelector').val("0").trigger("change");

                $('#manualName').select();                
            }

            // determine appropriate buttons to show
            $('#cancelButton').hide();
            /*
            // only show watch button for shows currently airing
            if (listing.start <= currentTime && listing.end >= currentTime) {
                $('#watchButton').show();
            }
            

            // only show record button for shows not already scheduled
            if (typeof listing.recording_id === 'undefined') {
                var now = new Date();
                if (episodeEndTime >= now) {
                    $('#recordOnceButton').show();
                    $('#recordSeriesButton').show();
                    $('#recordAdvancedButton').show();
                }                
            } else {
                // only show cancel button for shows already scheduled
                $('#cancelButton').show();
            }           
            */
            $('#recordOnceButton').show();

            // show modal
            $('#manualRecordModal').modal('show');

            // reinitialize bootstrap-select
            //$('.selectpicker').selectpicker();

            // were we passed an advanced record query? 
            if (typeof (advancedQuery) != "undefined") {
                // force focus to name, and highlight text
                $('#manualName').focus();
                $('#manualName').select();                
            }
        },
        edit(recurring) {            
            if (recurring.type == 8) {
                recurring.type = "advanced";
            }

            var self = this;

            this.existingRecurring = recurring;
            this.existingRecording = null;
            this.listing = null;

            $('#manualRecordModalTitle').text("Edit Recurring Recording");

            // populate pre padding options
            $('#manualPrePadding').empty();
            $('#manualPrePadding').append("<option value='default'>Default</option>");
            for (i = 0; i <= 120; i++) {
                $('#manualPrePadding').append("<option value='" + i + "'>" + i + "</option>");
            }

            // populate post padding options
            $('#manualPostPadding').empty();
            $('#manualPostPadding').append("<option value='default'>Default</option>");
            for (i = 0; i <= 120; i++) {
                $('#manualPostPadding').append("<option value='" + i + "'>" + i + "</option>");
            }

            // populate existing settings
            $('#manualName').val(recurring.name);
            $('#manualType').val(recurring.type);
            $('#manualType').val(recurring.type).trigger("change");
            $('#manualPrePadding').val(recurring.prePadding);
            $('#manualPostPadding').val(recurring.postPadding);
            $('#manualKeep').val(recurring.keep);

            if (recurring.channelID == 0) {
                $('#advancedChannel').val('all-channels');
            }
            else {
                $('#advancedChannel').val('this-channel');
            }          

            var defaultDateTime = moment(recurring.startTimeTicks * 1000);
            $('#manualDateTime').datetimepicker({
                format: 'YYYY-MM-DD HH:mm',
                date: defaultDateTime,                
                sideBySide: true
            });

            var duration = ((recurring.endTimeTicks - recurring.startTimeTicks) / 60);
            $('#manualDuration').val(duration);

            // load channel list
            $('#manualChannelSelector').empty();
            var url = 'services/service?method=channel.list';
            var preferredChannelGroup = localStorage.getItem('preferredChannelGroup');
            if (preferredChannelGroup !== null) {
                url += "&group_id=" + encodeURIComponent(preferredChannelGroup);
            }
            $('#manualChannelSelector').append('<option id="manualAnyChannel" value="0">[Any Channel]</option>');
            $('#manualAnyChannel').hide();
            $.getJSON(url, function (data) {
                self.channels = data.channels;
                // default to empty current show name
                data.channels.forEach(function (channel) {
                    $('#manualChannelSelector').append('<option value="' + channel.channelId + '">' + channel.channelName + '</option>');
                });
                var defaultChannel = data.channels[0].channelId;
                if (self.existingRecurring != null) {
                    defaultChannel = self.existingRecurring.channelID;
                }
                $('#manualChannelSelector').val(defaultChannel);
                $('#manualChannelSelector').val(defaultChannel).trigger("change");
            });

            // default field visibility 
            $('.manualKeywordSettings').hide();
            $('.manualAdvancedSettings').hide();
            $('.manualTimeDurationSettings').show();

            // advanced            
            if ($('#manualType').val() == "advanced") {

                $('#manualAdvanced').val(recurring.advancedRules);

                $('.manualKeywordSettings').hide();
                $('.manualTimeDurationSettings').hide();
                $('.manualAdvancedSettings').show();

                $('#manualAnyChannel').show();
                $('#manualChannelSelector').val(0);
                $('#manualChannelSelector').val(0).trigger("change");
            }

            // show modal
            $('#manualRecordModal').modal('show');
        },
        editOneOff(recording) {
            var self = this;

            this.existingeRcurring = null;
            this.existingRecording = recording;
            this.listing = null;

            $('#manualRecordModalTitle').text("Edit Manual Recording");

            // populate pre padding options
            $('#manualPrePadding').empty();
            $('#manualPrePadding').append("<option value='default'>Default</option>");
            for (i = 0; i <= 120; i++) {
                $('#manualPrePadding').append("<option value='" + i + "'>" + i + "</option>");
            }

            // populate post padding options
            $('#manualPostPadding').empty();
            $('#manualPostPadding').append("<option value='default'>Default</option>");
            for (i = 0; i <= 120; i++) {
                $('#manualPostPadding').append("<option value='" + i + "'>" + i + "</option>");
            }

            // populate existing settings
            $('#manualName').val(recording.name);
            $('#manualType').val("once");
            //$('#manualType').val(recurring.type).trigger("change");
            $('#manualPrePadding').val(recording.prePadding);
            $('#manualPostPadding').val(recording.postPadding);
            $('#manualKeep').val(1);

            $('#advancedChannel').val('this-channel');
            
            var defaultDateTime = moment(recording.startTime * 1000);
            $('#manualDateTime').datetimepicker({
                format: 'YYYY-MM-DD HH:mm',
                date: defaultDateTime,                
                sideBySide: true
            });

            var duration = (recording.duration / 60);
            $('#manualDuration').val(duration);

            // load channel list
            $('#manualChannelSelector').empty();
            var url = 'services/service?method=channel.list';
            var preferredChannelGroup = localStorage.getItem('preferredChannelGroup');
            if (preferredChannelGroup !== null) {
                url += "&group_id=" + encodeURIComponent(preferredChannelGroup);
            }
            $('#manualChannelSelector').append('<option id="manualAnyChannel" value="0">[Any Channel]</option>');
            $('#manualAnyChannel').hide();
            $.getJSON(url, function (data) {
                self.channels = data.channels;
                // default to empty current show name
                data.channels.forEach(function (channel) {
                    $('#manualChannelSelector').append('<option value="' + channel.channelId + '">' + channel.channelName + '</option>');
                });
                var defaultChannel = data.channels[0].channelId;
                if (self.existingRecurring != null) {
                    defaultChannel = self.existingRecording.channelID;
                }
                $('#manualChannelSelector').val(defaultChannel);
                $('#manualChannelSelector').val(defaultChannel).trigger("change");
            });

            // default field visibility 
            $('.manualKeywordSettings').hide();
            $('.manualAdvancedSettings').hide();
            $('.manualTimeDurationSettings').show();
            
            // show modal
            $('#manualRecordModal').modal('show');
        },
        onTypeChange(event) {
            //console.log(event.target.value)

            var self = this;

            // keyword recordings
            if ($('#manualType').val() == "keyword") {                
                $('.manualKeywordSettings').show();
                $('.manualTimeDurationSettings').hide();
                $('.manualAdvancedSettings').hide();

                $('#manualAnyChannel').show();                
                $('#manualChannelSelector').val(0);
                $('#manualChannelSelector').val(0).trigger("change");
            }
            // advanced recordings
            else if ($('#manualType').val() == "advanced") {

                $('.manualKeywordSettings').hide();
                $('.manualTimeDurationSettings').hide();
                $('.manualAdvancedSettings').show();

                $('#manualAnyChannel').show();
                $('#manualChannelSelector').val(0);
                $('#manualChannelSelector').val(0).trigger("change");
            }
            // all other recording types
            else {                
                $('.manualKeywordSettings').hide();
                $('.manualTimeDurationSettings').show();
                $('.manualAdvancedSettings').hide();

                $('#manualAnyChannel').hide();
                var defaultChannel = self.channels[0].channelId;
                $('#manualChannelSelector').val(defaultChannel);
                $('#manualChannelSelector').val(defaultChannel).trigger("change");

            }               
        },
        save() {
            // build up recording request
            var url = "services/service?method=recording.recurring.save";

            // handle once
            if ($('#manualType').val() == "once") {
                // ...one-off recording
                url = "services/service?method=recording.save";

                // channel            
                url += "&channel=" + $("#manualChannelSelector").val();

                // time
                var selectedDateTime = $("#manualDateTime").data("datetimepicker").date().unix();
                url += "&time_t=" + selectedDateTime;

                // duration
                var duration = $("#manualDuration").val() * 60;
                url += "&duration=" + duration;
            }

            // handle keyword
            else if ($('#manualType').val() == "keyword") {
                // type
                url += "&recurring_type=advanced";

                // channel            
                url += "&channel=" + $("#manualChannelSelector").val();

                // keyword
                var keyword = $("#manualKeyword").val();
                keyword = keyword.replace(/'/g, "''");

                // determine appropriate advanced rules for this keyword.
                var advanced = "";
                if ($('#manualKeywordType').val() == "title") {
                    advanced = "title like '%" + keyword + "%'";
                }
                else if ($('#manualKeywordType').val() == "description") {
                    advanced = "(title like '%" + keyword + "%' or description like '%" + keyword + "%')";
                }
                else if ($('#manualKeywordType').val() == "cast") {
                    advanced = "(cast_member like '%" + keyword + "%' or crew like '%" + keyword + "%')";
                }

                url += "&advanced=" + encodeURIComponent(advanced);
            }

            // handle advanced
            else if ($('#manualType').val() == "advanced") {
                // type
                url += "&recurring_type=advanced";

                // channel            
                url += "&channel=" + $("#manualChannelSelector").val();

                // advanced query
                var advanced = $("#manualAdvanced").val();
                url += "&advanced=" + encodeURIComponent(advanced);
            }

            // handle recurring
            else {
                url = "services/service?method=recording.recurring.save";

                // start/end times
                var startTime = $("#manualDateTime").data("datetimepicker").date().unix();
                url += "&start_time=" + startTime;

                var minutes = $("#manualDuration").val();
                var endTime = startTime + (minutes * 60);
                url += "&end_time=" + endTime;

                // recurring type
                url += "&recurring_type=" + $('#manualType').val()

                // channel            
                url += "&channel_id=" + $("#manualChannelSelector").val();
                
            }

            // name
            var name = $("#manualName").val();            
            url += "&name=" + encodeURIComponent(name);

            // keep
            if ($('#manualType').val() != "once") {                
                if ($('#manualKeep').val() != "all") {
                    url += "&keep=" + $('#manualKeep').val();
                }
            }

            if (this.existingRecurring != null) {
                // recurring id
                url += "&recurring_id=" + this.existingRecurring.id;
            }

            if (this.existingRecording != null) {
                // recurring id
                url += "&recording_id=" + this.existingRecording.id;
            }

            // pre-padding
            if ($('#manualPrePadding').val() != "default") {
                url += "&pre_padding=" + $('#manualPrePadding').val();
            }
            // post-padding
            if ($('#manualPostPadding').val() != "default") {
                url += "&post_padding=" + $('#manualPostPadding').val();
            }

            // directory
            if ($('#directory_id').val() != "default") {
                url += "&directory_id=" + $('#manualDirectory').val();
            }

            url += "&format=json";
            
            // schedule recording            
            $.ajax({
                url: url,
                crossDomain: true,
                type: 'get',
                async: true,
                success: function (response, textStatus, xhr) {
                    if (response.stat === "ok") {
                        console.log('Advanced record successful');
                        reloadRecordings();                        
                    } else { 
                        //alert("Failed to schedule recording\n\n" + response.msg);
                        showMessage("Scheduling Error", response.msg);
                    }
                },
                error: function (xhr, textStatus, errorThrown) {
                    var message = "Unable to schedule recording at this time. ";
                    if ((xhr.readyState == 4 || xhr.readyState == 0) && xhr.status == 0) {
                        message += "Unable to connect to server.";
                    }
                    showMessage("Scheduling Error", message);                    
                }
            });            
        }        
    }
});
