﻿window.onload = function () {
    var app = new Vue({
        el: '#app',
        data: {
        }
    });
};

Vue.component('live_channels_list', {
    data: function () {
        return {
            items: [],
            filtered: []
        }
    },
    props: ['recurring'],

    template: '<div id="liveChannelsList" >\
                    <div class="row">\
                            <input class="form-control" spellcheck="false" id="channelFilter" @input="filterHandler" placeholder="type to filter">\
                    </div>\
                    <div class="row scrolling">\
                        <div v-for="(item, index) in filtered" class="col-12 row-no-padding">\
                            <div id="channel" @click="trigger({ index })" class="live-channel-list-item bg-light no-select">\
                                <span class="text-primary">{{ item.channelNumberFormated }} - {{ item.channelName }}</span><br>\
                                <span class="text-dark text-nowrap truncate">{{item.currentShowName}}</span><br>\
                                <span><small class="text-secondary">{{ item.currentShowPeriod }}</small></span><br>\
                                <div v:if="item.channelIcon == true" class="float-right channel-icon-container"><img class="channel-icon" v-bind:src="item.iconUrl"></div>"\
                            </div>\
                        </div>\
                    </div>\
                </div>',
    mounted: function () {
        var self = this;
        var url = 'services/service?method=channel.list';

        var preferredChannelGroup = localStorage.getItem('preferredChannelGroup');
        if (preferredChannelGroup !== null) {
            url += "&group_id=" + encodeURIComponent(preferredChannelGroup);
        }

        $.getJSON(url, function (data) {
            // default to empty current show name
            data.channels.forEach(function (element) {
                element.currentShowName = "";
                element.currentShowPeriod = "";
            });

            // populate list
            self.items = data.channels;            
            self.filtered = data.channels;            

            // pull in current listings
            var currentListingsURL = "services/service?method=channel.listings.current&random=0.7031164544624411";
            if (preferredChannelGroup !== null) {
                currentListingsURL += "&group_id=" + encodeURIComponent(preferredChannelGroup);
            }
            $.getJSON(currentListingsURL, function (listings) {                
                self.items.forEach(function (channel) {
                    //console.log("channel: " + channel.channelId);
                    channel.iconUrl = "";
                    if (channel.channelIcon) {
                        channel.iconUrl = "service?method=channel.icon&channel_id=" + channel.channelId;
                    }
                    listings.forEach(function (channelListing) {
                        if (channel.channelId === channelListing.channel.channel_id) {
                            channel.currentShowName = channelListing.channel.listings[0].name;

                            var episodeStartTime = new Date(channelListing.channel.listings[0].start * 1000);
                            var episodeEndTime = new Date(channelListing.channel.listings[0].end * 1000);
                            channel.currentShowPeriod = '' + episodeStartTime.toLocaleDateString() + ' ' + episodeStartTime.toLocaleTimeString() + ' - ' + episodeEndTime.toLocaleTimeString();
                        }
                    });
                });
            });
        });
    },
    methods: {
        clearFilter() {
            var self = this;
            self.filtered = self.items;
            $('#channelFilter').val("");
        },
        trigger(args) {
            var channel = this.filtered[args.index];            
            startChannel(channel);
            //var title = channel.channelNumberFormated + " - " + channel.channelName;
            //window.location.href = 'player.html?channel_id=' + channel.channelId + "&title=" + encodeURIComponent(title);
        },
        filterHandler(args) {
            var self = this;

            // get filter text
            var text = $('#channelFilter').val().toLowerCase();
            console.log("filter=" + text);

            // find matching channels
            var filtered = [];
            self.items.forEach(function (channel) {
                if (channel.channelName.toLowerCase().includes(text)) {
                    filtered.push(channel);
                }
            });
            self.filtered = filtered;

            //var channelList = app.__vue__.$refs.channelList;
            //channelList.filter(text);
        }
    }
});
