﻿window.onload = function () {
    var app = new Vue({
        el: '#app',
        data: {
        }
    });
};

Vue.component('listings_list', {
    data: function () {
        return {
            items: [],
            channels: []
        };
    },

    template: '<div id="listingsList" >\
                    <div v-if="items.length > 0">\
                        <div v-for="(item, index) in items" class="col-12 row-no-padding2">\
                            <div id="device" @click="trigger({ index })" v-bind:class="getClass(item)">\
                                <div class="row">\
                                    <div class="col-3 text-nowrap">\
                                        <span class="text-primary text-nowrap">{{ item.name }}</span>\
                                    </div>\
                                    <div class="col-1 text-nowrap">\
                                        <span class="text-dark">{{ item.channelName }}</span>\
                                    </div>\
                                    <div class="col-3 text-nowrap"">\
                                        <span class="text-dark text-nowrap">{{ item.period }}</span>\
                                    </div>\
                                    <div class="col-5 text-nowrap">\
                                        <span class="text-secondary"><b>{{seasonEpisodeExtra(item)}}{{item.subtitle}}</b> {{ item.description }}</span>\
                                    </div>\
                                </div>\
                            </div>\
                        </div>\
                    </div>\
                </div>',
    mounted: function () {
        var self = this;     
        var url = 'services/service?method=channel.list&format=json';
        $.getJSON(url, function (data) {
            for (var i = 0, len = data.channels.length; i < len; i++) {
                var channel = data.channels[i];
                self.channels[channel.channelId] = channel;
            }
        });
    },
    methods: {
        getClass(listing) {
            if (listing.hasOwnProperty('recording_id'))
                return 'listing-item bg-scheduled';

            if (showNewIndicator == true && listing.firstrun)
                return 'listing-item bg-light new-listing';
            else
                return 'listing-item bg-light';
        },
        seasonEpisodeExtra(item) {
            var self = this;
            if (item.hasOwnProperty("season")) {
                var seasonEpisode = "S" + ("0" + item.season).slice(-2) + "E" + ("0" + item.episode).slice(-2);
                if (item.hasOwnProperty("subtitle") == false) {
                    return seasonEpisode;
                }
                if (item.subtitle != seasonEpisode) {
                    return seasonEpisode + " ";
                }
            }
            return "";
        },
        showListings(listings) {
            var self = this;      
            // look up channel names, and start/end time info, for each listing
            for (var i = 0, len = listings.length; i < len; i++) {
                var listing = listings[i];

                var channel = self.channels[listing.channelId];
                if (typeof (channel) == "undefined") {
                }
                else {
                    listing.channelName = channel.channelName;
                }

                var episodeStartTime = new Date(listing.start * 1000);
                var episodeEndTime = new Date(listing.end * 1000);
                listing.period = '' + episodeStartTime.toLocaleDateString() + ' ' + episodeStartTime.toLocaleTimeString() + ' - ' + episodeEndTime.toLocaleTimeString();

                // hack to make some DVB EPG listings look nicer (remove hardcoded season/episode number as part of the description)
                if (listing.hasOwnProperty("season")) {
                    var surplus = "S" + listing.season + " E" + listing.episode + " ";
                    if (listing.description.startsWith(surplus)) {
                        listing.description = listing.description.replace(surplus, "")                        
                    }
                }
                    
            }
            // store listings
            self.items = listings;                
        },
        trigger(args) {            
            var self = this;     
            var listing = self.items[args.index];
            listingClicked(listing);
        }
    }
});
