﻿window.onload = function () {
    var app = new Vue({
        el: '#app',
        data: {
        }
    });
};

Vue.component('import_recordings_modal', {
    data: function () {
        return {
            listing: "",
            files: []
        };
    },    
    template: '<div class="modal fade" id="importRecordingsModal" tabindex="-1" role="dialog" aria-labelledby="importRecordingsModalLabel" aria-hidden="true">\
                    <div class= "modal-dialog modal-lg" role="document" >\
                        <div class="modal-content">\
                            <div class="modal-header">\
                                <h5 class="modal-title">Import Recordings</h5>\
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">\
                                    <span aria-hidden="true">&times;</span>\
                                </button>\
                            </div>\
                            <div class="modal-body">\
                                <div class="form-inline">\
                                    <div class="col-md-12">\
                                        <div class="form-group">\
                                            <form id="importForm" action="#" enctype="multipart/form-data" class="col-12" method="post">\
                                                <div class="custom-file col-12" id="customFile" lang="es">\
                                                    <input type="file" class="custom-file-input" id="importFile" @change="prepareUpload" aria-describedby="fileHelp">\
                                                    <label id="importFilename" class="custom-file-label text-dark" for="importFile">\
                                                        Select .xml or .zip file...\
                                                    </label>\
                                                </div>\
                                            </form>\
	                                    </div>\
                                    </div>\
                                </div>\
                            </div>\
                            <div class="modal-footer">\
                                <button type="button" class="btn btn-primary" @click="uploadFiles">Import</button>\
                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>\
                            </div>\
                        </div>\
                    </div>\
               </div>',
    mounted: function () {
        var self = this;   
        self.loaded = false;
        
        $(document).on('change', ':file', function () {
            var input = $(this),
                numFiles = input.get(0).files ? input.get(0).files.length : 1,
                label = input.val().replace(/\\/g, '/').replace(/.*\//, '');
            $("#importFilename").text(label);
            input.trigger('fileselect', [numFiles, label]);
        });

        $(':file').on('fileselect', function (event, numFiles, label) {
            console.log(numFiles);
            console.log(label);
        });        

    },
    methods: {
        show() {
            $("#importFilename").text("Select .xml or .zip file...");
            $('#importRecordingsModal').modal('show');
        },        
        importRecordings() {

        },        
        prepareUpload(event)
	    {
            this.files = event.target.files;
        },
        uploadFiles(event)
        {
            $("#importRecordingsModal .close").click()

            event.stopPropagation(); // Stop stuff happening
            event.preventDefault(); // Totally stop stuff happening

            // Create a formdata object and add the files
            var data = new FormData();
            $.each(this.files, function (key, value) {
                data.append(key, value);
            });
            
            $.ajax({
                url: 'import',
                type: 'POST',
                data: data,
                cache: false,
                dataType: 'json',
                processData: false, // Don't process the files
                contentType: false, // Set content type to false as jQuery will tell the server its a query string request
                success: function (data, textStatus, jqXHR) {
                    if (typeof data.error === 'undefined') {
                        //showMessage("Import Recordings", data.result);
                        alert(data.result);
                    }
                    else {
                        console.log('Error importing: ' + data.error);
                    }
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    console.log('Error importing: ' + textStatus);
                }
            });
        }
    }
});
