﻿window.onload = function () {
    var app = new Vue({
        el: '#app',
        data: {
        }
    });
};

Vue.component('genre_modal', {
    data: function () {
        return {
            genres: [],
            selectedGenre: null
        };
    },    
    template: '<div class="modal fade" id="genreModal" tabindex="-1" role="dialog" aria-labelledby="genreModalLabel" aria-hidden="true">\
                    <div class= "modal-dialog" role="document" >\
                        <div class="modal-content">\
                            <div class="modal-header">\
                                <h5 class="modal-title">Genre</h5>\
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">\
                                    <span aria-hidden="true">&times;</span>\
                                </button>\
                            </div>\
                            <div class="modal-body">\
                                <div class="form-inline">\
                                    <div class= "col-md-12 form-group">\
                                        <select id="genres" class="custom-select my-1 mr-sm-2 col-12" data-container="body">\
                                            <option v-for="(genre, index) in genres" v-bind:value="genre.name">{{ genre.name }}</option>"\
                                        </select>\
                                        <input id="genreColor" type="text" class="form-control col-12" value="rgb(255, 128, 0)" />\
                                    </div>\
                                </div>\
                            </div>\
                            <div class="modal-footer">\
                                <button type="button" class="btn btn-secondary" @click="saveGenre()" data-dismiss="modal">OK</button>\
                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>\
                            </div>\
                        </div>\
                    </div>\
               </div>',
    mounted: function () {
        var self = this;   
        self.loaded = false;
    },
    methods: {
        hexToRgb(hex) {
            var result = /^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(hex);
            return result ? {
                a: parseInt(result[1], 16),
                r: parseInt(result[2], 16),
                g: parseInt(result[3], 16),
                b: parseInt(result[4], 16)
            } : null;
        },
        saveGenre() {
            console.log("save genre");
        },
        show() {                              
            var self = this;

            $('#genreColor').colorpicker()

            var url = 'services/service?method=system.genre&format=json';
            $.getJSON(url, function (genres) {                
                self.genres = genres;                
            });

            $('#genreModal').modal('show');    

            $('#genres').on('change', function () {
                var genreName = $('#genres').val();
                for (var i = 0, len = self.genres.length; i < len; i++) {
                    var genre = self.genres[i];
                    if (genre.name === genreName) {
                        selectedGenre = genre;

                        $('#genreColor').css('background-color', "#" + genre.color.substring(3, 6));

                        console.log("test");
                        break;
                    }
                }
            });

            $('#genreColor').on('colorpickerChange', function (event) {
                selectedGenre.color = event.color.toString()
                $('#genreColor').css('background-color', event.color.toString());
            });
        }
    }
});
