﻿window.onload = function () {
    var app = new Vue({
        el: '#app',
        data: {
        }
    });
};

Vue.component('epg_sources', {
    data: function () {
        return {
            items: []
        }
    },
    props: ['recurring'],

    template: '<div id="epgSourceList" >\
                    <div class="row">\
                        <div v-for="(item, index) in items" class="col-12">\
                            <div id="device" class="small-item bg-light">\
                                <div class="row">\
                                    <div><span class="text-primary">{{ item.name }}</span></div>\
                                    <div v-if="editable(item)" @click="edit(item)"  class="ml-auto float-md-right"><i class="fa fa-lg fa-cog text-secondary"></i></div>\
                                    <div v-if="deletable(item)" @click="deleteLineup(item)"  class="ml-auto float-md-right"><i class="fa fa-lg fa-trash text-secondary"></i></div><br>\
                                </div>\
                            </div>\
                        </div>\
                    </div>\
                </div>',
    mounted: function () {
        var self = this;
        self.reloadSources();
    },
    methods: {
        reloadSources() {
            var self = this;
            var url = 'services/service?method=setting.epg.sources&format=json';
            $.getJSON(url, function (data) {
                var sources = [];
                data.forEach(function (source) {
                    if (source.id != 'none' && source.id != 'freesat') {
                        sources.push(source);
                    }
                });

                self.items = sources;

                parent.postMessage("resize", document.location);
            });
        },
        deletable(item) {
            if (item.id.startsWith("schedulesdirect-") || item.id.startsWith("xmltv-")) {
                return true;
            }
            return false;
        },
        editable(item) {
            if (item.id.startsWith("dvb")) {
                return true;
            }
            return false;
        },
        edit(item) {
            if (window.eventBus != null) {
                window.eventBus.$emit('editDVBEPG', "");
            }
        },
        deleteLineup(item) {            
            var self = this;
            var url = 'services/service?method=setting.removelineup&format=json';
            url += "&id=" + encodeURIComponent(item.id);
            $.getJSON(url, function (data) {
                self.reloadSources();
            });        
        }
    }
});
