﻿window.onload = function () {
    var app = new Vue({
        el: '#app',
        data: {
        }
    });
};

Vue.component('edit_user_modal', {
    data: function () {
        return {
            listing: "",
            user: "default"
        };
    },
    template: '<div class="modal fade" id="editUserModal" tabindex="-1" role="dialog" aria-labelledby="editUserModal" aria-hidden="true">\
                    <div class= "modal-dialog" role="document" >\
                        <div class="modal-content">\
                            <div class="modal-header">\
                                <h5 id="profileTitle" class="modal-title"><i class="fas fa-user"></i> Edit User</h5>\
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">\
                                    <span aria-hidden="true">&times;</span>\
                                </button>\
                            </div>\
                            <div class="modal-body">\
                                <div class="form">\
                                    <div class="form-row">\
                                        <label class="col-sm-4 col-form-label" for="name">Username:</label>\
                                        <input type="text" id="webapp-username" class="form-control col-7" placeholder="Username" autofocus>\
                                    </div>\
                                    <div class="form-row">\
                                        <label class="col-sm-4 col-form-label" for="name">Current Password:</label>\
                                        <input id="webapp-password" class="form-control col-7 fake-pwd" autofocus>\
                                    </div>\
                                    <div class="form-row">\
                                        <label class="col-sm-4 col-form-label" for="name">New Password:</label>\
                                        <input id="newpassword1" class="form-control col-7 fake-pwd" autocomplete="off">\
                                    </div>\
                                    <div class="form-row">\
                                        <label class="col-sm-4 col-form-label" for="name">Password Again:</label>\
                                        <input id="newpassword2" class="form-control col-7 fake-pwd" autocomplete="off">\
                                    </div>\
                                    <div class="form-row">\
                                        <label class="col-sm-4 col-form-label" for="selectedChannelGroup">Permissions:</label>\
                                        <select id="selectedChannelGroup" class="form-control" data-container="body">\
                                            <option value="full">Full Access</option>\
                                            <option value="watchScheduleDelete">Watch/Schedule/Delete</option>\
                                            <option value="watchSchedule">Watch/Schedule</option>\
                                            <option value="watch">Watch</option>\
                                        </select>\
                                    </div>\
                                </div>\
                            </div>\
                            <div class="modal-footer">\
                                <button id="saveChanges" type="button" class= "btn btn-primary" @click="updateProfile" data-dismiss="modal"> Save</button >\
                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>\
                            </div>\
                        </div>\
                    </div>\
               </div>',
    mounted: function () {
        var self = this;
        self.loaded = false;        
    },
    methods: {
        show(user) {    
            var self = this;
            self.profile = user;
           // $('#profileTitle').text("Add/Edit user");

            /*
            // load bitrate for this profile
            $('#bitrate').val("");
            var url = 'services/service?method=setting.transcode.profile&profile=' + profile;
            $.getJSON(url, function (data) {
                $('#bitrate').val(data.bitrate);
            });*/

            // show modal
            $('#editUserModal').modal('show');            
        },
        updateProfile() {
            var self = this;
            var url = 'services/service?method=setting.transcode.profile&profile=' + self.profile;
            url += "&bitrate=" + encodeURIComponent($('#bitrate').val());
            // do request
            $.ajax({
                url: url,
                headers: { "Content-Type": "text/plain" },
                crossDomain: true,
                type: 'get',
                async: true,
                success: function (response, textStatus, xhr) {
                    console.log("profile");
                    $('#editProfileModal').modal('hide');
                },
                error: function (xhr, textStatus, errorThrown) {
                    console.log('Error updating profile: ' + textStatus + ": " + errorThrown);
                }
            });
        }
    }
});
