﻿window.onload = function () {
    var app = new Vue({
        el: '#app',
        data: {
        }
    });
};

Vue.component('edit_profile_modal', {
    data: function () {
        return {
            listing: "",
            profile: "default"
        };
    },
    template: '<div class="modal fade" id="editProfileModal" tabindex="-1" role="dialog" aria-labelledby="detailsModalLabel" aria-hidden="true">\
                    <div class= "modal-dialog" role="document" >\
                        <div class="modal-content">\
                            <div class="modal-header">\
                                <h5 id="profileTitle" class="modal-title">Edit Streaming Profile</h5>\
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">\
                                    <span aria-hidden="true">&times;</span>\
                                </button>\
                            </div>\
                            <div class="modal-body">\
                                <div class="form-inline">\
                                    <div class= "col-md-12 form-group">\
                                        <label for="name" class="col-sm-4 col-form-label">Bitrate (Kbps):&nbsp;</label>\
                                        <input type="text" class="col-sm-8 form-control" id="bitrate">&nbsp;\
                                    </div>\
                                </div>\
                            </div>\
                            <div class="modal-footer">\
                                <button id="saveChanges" type="button" class= "btn btn-primary" @click="updateProfile" data-dismiss="modal"> Save</button >\
                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>\
                            </div>\
                        </div>\
                    </div>\
               </div>',
    mounted: function () {
        var self = this;
        self.loaded = false;        
    },
    methods: {
        show(profile) {    
            var self = this;
            self.profile = profile;
            $('#profileTitle').text("Edit Streaming Profile: " + profile);

            // load bitrate for this profile
            $('#bitrate').val("");
            var url = 'services/service?method=setting.transcode.profile&profile=' + profile;
            $.getJSON(url, function (data) {
                $('#bitrate').val(data.bitrate);
            });

            // show modal
            $('#editProfileModal').modal('show');            
        },
        updateProfile() {
            var self = this;
            var url = 'services/service?method=setting.transcode.profile&profile=' + self.profile;
            url += "&bitrate=" + encodeURIComponent($('#bitrate').val());
            // do request
            $.ajax({
                url: url,
                headers: { "Content-Type": "text/plain" },
                crossDomain: true,
                type: 'get',
                async: true,
                success: function (response, textStatus, xhr) {
                    console.log("profile");
                    $('#editProfileModal').modal('hide');
                },
                error: function (xhr, textStatus, errorThrown) {
                    console.log('Error updating profile: ' + textStatus + ": " + errorThrown);
                }
            });
        }
    }
});
