﻿window.onload = function () {
    var app = new Vue({
        el: '#app',
        data: {
        }
    });
};

Vue.component('edit_channel_modal', {
    data: function () {
        return {
            listing: "",
            channel: null
        };
    },    
    template: '<div class="modal fade" id="channelDetailsModal" tabindex="-1" role="dialog" aria-labelledby="channelDetailsModalLabel" aria-hidden="true">\
                    <div class= "modal-dialog modal-lg" role="document" >\
                        <div class="modal-content">\
                            <div class="modal-header">\
                                <h5 class="modal-title" id="channelMappingModalTitle">Edit Channel Details</h5>\
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">\
                                    <span aria-hidden="true">&times;</span>\
                                </button>\
                            </div>\
                            <div class="modal-body">\
                                <div class= "form-inline">\
                                    <div class="col-md-12 form-group extra-vertical">\
                                        <label class="col-sm-2 col-form-label" for="name">Name</label>\
                                        <input type="text" id="channelName" class="form-control"></select>\
                                    </div>\
                                </div>\
                                <div class= "form-inline">\
                                    <div class="col-md-12 form-group extra-vertical">\
                                        <label class="col-sm-2 col-form-label" for="name">Number</label>\
                                        <input type="text" id="channelNumber" class="form-control"></select>\
                                    </div>\
                                </div>\
                                <div class= "form-inline">\
                                    <div class="col-md-12 form-group extra-vertical">\
                                        <label class="col-sm-2 col-form-label" for="name">Source</label>\
                                        <select id="epgSource" class="custom-select my-1 mr-sm-2 col-9" data-container="body"></select>\
                                    </div>\
                                </div>\
                                <div id="mapping" class= "form-inline extra-vertical">\
                                    <div class="col-md-12 form-group">\
                                        <label class="col-sm-2 col-form-label" for="name">Mapping</label>\
                                        <select id="channelMapping" class="custom-select my-1 mr-sm-2 col-9" data-container="body"></select>\
                                    </div>\
                                </div>\
                            </div>\
                            <div class= "modal-footer">\
                                <button type="button" class="btn btn-secondary" @click="save()" data-dismiss="modal">Save</button>\
                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>\
                            </div>\
                        </div>\
                    </div>\
               </div>',
    mounted: function () {
        var self = this;   
        self.loaded = false;
    },
    methods: {
        showChannelMapping(channel) {
            var self = this;
            self.channel = channel;

            $('#epgSource').val('none').change();

            var url = 'services/service?method=setting.epg.sources&channel_id=' + self.channel.channelId;
            $.getJSON(url, function (sources) {         
                var select = null;
                $('#epgSource').empty();
                for (var i = 0, len = sources.length; i < len; i++) {
                    var source = sources[i];
                    $('#epgSource').append("<option value='" + source.id + "'>" + source.name + "</option>");
                    if (source.hasOwnProperty("selected")) {
                        select = source.id;
                    }
                }

                // add additionals...
                $('#epgSource').append("<option value='addsd'>...Add Schedules Direct Lineup....</option>");
                $('#epgSource').append("<option value='addxmltv'>...Add XMLTV Lineup....</option>");
               
                if (select != null) {
                    $('#epgSource').val(select).change();
                }
            });

            $('#channelName').val(channel.channelName);
            $('#channelNumber').val(channel.channelNumberFormated);

            $('#mapping').hide();
            $('#schedulesdirect').hide();
            $('#xmltv').hide();
            $('#channelDetailsModal').modal('show');   
            /*
            console.log("initiating EPG update...");            
            $('#updateEPGStatus').text("Initiating EPG updates...");
            $('#updateEPGModal').modal('show');            
            
            var url = 'services/service?method=system.epg.update&format=json';
            $.getJSON(url, function (data) {
                if (data.stat === "ok") {
                    $('#updateEPGStatus').text("Starting EPG update");
                    //self.items = data.status;

                    self.timer = setInterval(self.checkEPGUpdateStatus, 1000);
                } else {
                    alert("Unable to Update EPG at this time");
                }
            });      */

            // show appropriate EPG settings
            $('#epgSource').on('change', function () {
                var epgSource = $('#epgSource').val();

                if (epgSource == "addsd") {
                    $('#channelDetailsModal').modal('hide');
                    var modal = app.__vue__.$refs.addSDModal;
                    modal.show();
                    return;
                }
                else if (epgSource == "addxmltv") {
                    $('#channelDetailsModal').modal('hide');
                    var modal = app.__vue__.$refs.addXMLTVModal;
                    modal.show();
                    return;
                }


                $('#mapping').hide();                

                if (epgSource.indexOf("xmltv") !== -1 || epgSource.indexOf("schedulesdirect") !== -1) {
                    $('#channelMapping').empty();                    
                    $('#channelMapping').append("<option value='none'>...loading...</option>");
                    
                    var url = 'services/service?method=setting.epg.mappings&format=json&source=' + epgSource + "&channel_id=" + self.channel.channelId;
                    $.getJSON(url, function (mappings) {                        
                        $('#channelMapping').empty();
                        var select = null;
                        for (var i = 0, len = mappings.length; i < len; i++) {
                            var mapping = mappings[i];
                            $('#channelMapping').append("<option value='" + mapping.id + "'>" + mapping.name + "</option>");
                            if (mapping.hasOwnProperty("selected")) {
                                select = mapping.id;
                            }
                        }
                        if (select != null) {
                            $('#channelMapping').val(select).change();
                        }
                    });

                    $('#mapping').show();                    
                }                
            });      
        },
        save() {
            var self = this;
            var epgSource = $('#epgSource').val();
            var channelNumber = $('#channelNumber').val();
            var channelName = $('#channelName').val();
            var url = 'services/service?method=setting.channel.update&channel_id=' + self.channel.channelId + '&channel_name=' + encodeURIComponent(channelName) + '&channel_number=' + encodeURIComponent(channelNumber) + '&source=' + encodeURIComponent(epgSource);
            if (epgSource.indexOf("xmltv") !== -1 || epgSource.indexOf("schedulesdirect") !== -1) {
                var mapping = $('#channelMapping').val();
                url += '&mapping=' + mapping;
            }
            $.getJSON(url, function (mappings) {
                console.log("channel mapped");
                reloadChannels();
            });
        }
    }
});
