﻿window.onload = function () {
    var app = new Vue({
        el: '#app',
        data: {
        }
    });
};

Vue.component('device_status_modal', {
    data: function () {
        return {
            items: [],
            listing: ""
        };
    },    
    template: '<div class="modal fade" id="deviceStatusModal" tabindex="-1" role="dialog" aria-labelledby="deviceStatusModalLabel" aria-hidden="true">\
                    <div class= "modal-dialog modal-lg" role="document" >\
                        <div class="modal-content">\
                            <div class="modal-header">\
                                <h5 class="modal-title" id="deviceStstusModalTitle">Device Status</h5>\
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">\
                                    <span aria-hidden="true">&times;</span>\
                                </button>\
                            </div>\
                            <div class="modal-body">\
                                <div v-if="noDevicesActive" class="text-center text-primary">\
                                    No devices are currently active \
                                </div>\
                                <div v-if="!noDevicesActive" v-for="(item, index) in items" class="col-12 row-no-padding">\
                                    <div id="recording" @click="trigger({ index })" class="device-status-list-item">\
                                        <div class="row">\
                                            <div class="col-12">\
                                                <span class="text-primary">{{ item.identifier }}</span>\
                                                <span class="text-success">{{ item.signal }}</span>\
                                            </div>\
                                            <div v-for="(stream, streamIndex) in item.streams" class="col-12 row-no-padding">\
                                                <div class="col-12">\
                                                    <p> - {{ stream }}</p>\
                                                </div>\
                                            </div>\
                                        </div>\
                                    </div>\
                                </div>\
                            </div>\
                            <div class= "modal-footer">\
                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>\
                            </div>\
                        </div>\
                    </div>\
               </div>',
    mounted: function () {                
    },
    computed: {
        noDevicesActive: function () {
            var self = this;
            if (self.items.length === 0)
                return true;
            return false;
        }
    },
    methods: {
        showStatus() {
            var self = this;
            var url = 'services/service?method=system.status&format=json';
            $.getJSON(url, function (data) {
                if (data.stat === "ok") {
                    self.items = [];
                    for (var i = 0, len = data.status.length; i < len; i++) {
                        var device = data.status[i];
                        if (device.streams.length > 0) {
                            self.items.push(device);
                        }
                    }
                    //self.items = data.status;
                } else {
                    alert("Unable to query system status.");
                }
            });
            // show modal
            $('#deviceStatusModal').modal('show');            
        }
    }
});
