﻿window.onload = function () {
    var app = new Vue({
        el: '#app',
        data: {
        }
    });
};

Vue.component('device_channels_grid', {
    data: function () {
        return {
            captureSourceOID: 0,
            items: [],
            loaded: false
        }
    },
    props: ['recurring'],

    template: '<div id="channelsList" >\
                    <div v-if="loadedButNoChannels" class="text-center text-primary">\
                        This device currently has no channels, hit the Scan or Import buttons to add channels to this device. \
                    </div>\
                    <div v-if="items.length > 0">\
                        <table class="device-channels-table table table-bordered table-responsive-md table-striped text-center">\
                            <tr>\
                                <th class="text-left" width="10%">Number</th>\
                                <th class="text-left" width="20%">Name</th>\
                                <th class="text-left" width="70%">Details<div class="float-right"><i @click="deleteChannels()" class="fa fa-trash fa-lg"></i></div></th>\
                            </tr>\
                            <tr v-for="(item, index) in items" @click="toggle(item)" v-bind:class="{ channelSelected: item.selected }">\
                                <td class="text-left">{{ item.channelNumberFormated }}</td>\
                                <td class="text-left text-nowrap">{{ item.channelName }}</td>\
                                <td class="text-left text-nowrap">{{ item.channelDetails }}</td>\
                            </tr>\
                        </table>\
                    </div>\
                </div>',
    mounted: function () {
        var self = this;   
        self.loaded = false;                
    },
    computed: {
        loadedButNoChannels: function () {
            var self = this;
            if (self.items.length === 0 && self.loaded === true)
                return true;
            return false;
        }
    },
    methods: {
        trigger(args) {
            var page = this.items[args.index].sourceType.replace("-", "").toLowerCase();
            var id = this.items[args.index].id;            
            window.location.href = page + '.html?id=' + id;
        },
        toggle(channel) {
            var self = this;
            console.log("channel clicked");
            channel.selected = !channel.selected;                      

            // does this page want to be notified about selected channel changes
            if (typeof onSelectedChannelChange === 'function') {                
                var selectedChannels = [];
                self.items.forEach(function (channel) {
                    if (channel.selected) {
                        selectedChannels.push(channel);
                    }
                });      
                onSelectedChannelChange(selectedChannels);
            }

        },
        deleteChannels() {
            var self = this;

            // get the list of selected channels
            var selectedChannels = "";
            var selectedChannelCount = 0;
            self.items.forEach(function (channel) {
                if (channel.selected) {
                    selectedChannels += channel.channelId + ",";
                    selectedChannelCount++;
                }
            });

            // if no channels are selected, we're going to delete all channels            
            var message = "these " + selectedChannelCount + " channels from this device?";
            if (selectedChannelCount === 1) {
                message = "this channel from this device?";
            }
            else if (selectedChannelCount === 0) {
                message = "all channel from this device?";
                selectedChannels = "0";
            }
            
            if (confirm('Are you sure you want to delete ' + message)) {
                var startScanURL = "services/service?method=setting.channel.delete&source_id=" + self.captureSourceOID + "&format=json&channel_id=" + selectedChannels;
                $.getJSON(startScanURL, function (result) {
                    // reload the channel list
                    self.reloadForSource(self.captureSourceOID);
                });
            }                   
        },
        reloadForSource(captureSourceOID) {
            var self = this;
            var url = 'services/service?method=channel.list&source_id=' + captureSourceOID + '&format=json';
            self.captureSourceOID = captureSourceOID;
            $.getJSON(url, function (data) {
                // default to not selected
                data.channels.forEach(function (element) {
                    element.selected = false;
                });
                self.items = data.channels;
                self.loaded = true;

                parent.postMessage("resize", document.location);

                // let parent page know we loaded the channels
                loadedChannels(data.channels);

                if (typeof onSelectedChannelChange === 'function') {
                    var selectedChannels = [];
                    onSelectedChannelChange(selectedChannels);
                }
            });
        }

    }
});
