﻿window.onload = function () {
    var app = new Vue({
        el: '#app',
        data: {
        }
    });
};

Vue.component('channels_grid', {
    data: function () {
        return {
            items: []
        }
    },
    props: ['recurring'],

    template: '<div id="channelsGrid" >\
                    <div class="row">\
                        <div v-for="(item, index) in items" class="col-lg-3 col-md-4 col-sm-6 col-xs-12 row-no-padding">\
                            <div id="channel" @click="trigger({ index })" v-bind:class="getClass(item)">\
                                <span class="text-primary">{{ item.channelNumberFormated }} - {{ item.channelName }}</span><br>\
                                <span class="text-dark text-nowrap truncate">{{item.currentShowName}}</span><br>\
                                <span><small class="text-secondary">{{ item.currentShowPeriod }}</small></span><br>\
                                <div v:if="item.channelIcon == true" class="float-right channel-icon-container"><img class="channel-icon" v-bind:src="getIconUrl(item)"></div>"\
                            </div>\
                        </div>\
                    </div>\
                </div>',
    mounted: function () {
        var self = this;
        var url = 'services/service?method=channel.list';

        var preferredChannelGroup = localStorage.getItem('preferredChannelGroup');
        if (preferredChannelGroup !== null) {
            url += "&group_id=" + encodeURIComponent(preferredChannelGroup);
        }

        $.getJSON(url, function (data) {
            // default to empty current show name
            data.channels.forEach(function (element) {
                element.currentShowName = "";
                element.currentShowPeriod = "";
            });

            // populate list
            self.items = data.channels;            

            // pull in current listings
            var currentListingsURL = "services/service?method=channel.listings.current&colors=true&random=0.7031164544624411";
            if (preferredChannelGroup !== null) {
                currentListingsURL += "&group_id=" + encodeURIComponent(preferredChannelGroup);
            }
            $.getJSON(currentListingsURL, function (listings) {                
                self.items.forEach(function (channel) {
                    //console.log("channel: " + channel.channelId);
                    channel.iconUrl = "";
                    if (channel.channelIcon) {
                        channel.iconUrl = "service?method=channel.icon&channel_id=" + channel.channelId;
                    }
                    listings.forEach(function (channelListing) {
                        if (channel.channelId === channelListing.channel.channel_id) {
                            var listing = channelListing.channel.listings[0];
                            channel.currentShowName = listing.name;                            
                            channel.now = listing;

                            var episodeStartTime = new Date(listing.start * 1000);
                            var episodeEndTime = new Date(listing.end * 1000);
                            channel.currentShowPeriod = '' + episodeStartTime.toLocaleDateString() + ' ' + episodeStartTime.toLocaleTimeString() + ' - ' + episodeEndTime.toLocaleTimeString();
                        }
                    });
                });
            });
        });
    },
    methods: {
        trigger(args) {
            var channel = this.items[args.index];            
            var title = channel.channelNumberFormated + " - " + channel.channelName;
            window.location.href = 'player.html?channel_id=' + channel.channelId + "&title=" + encodeURIComponent(title);
        },
        getClass(item) {
            if (item.hasOwnProperty('now')) {
                var listing = item.now;
                if (listing.hasOwnProperty('color')) {
                    var color = listing.color;
                    return "channel-list-item bg-light " + color;
                }                
            }
            return "channel-list-item bg-light";
        },
        getIconUrl(item) {
            var channel = item;
            if (channel.channelIcon) {
                return "service?method=channel.icon&channel_id=" + channel.channelId;
            }
            return "";
        }
    }
});
