﻿window.onload = function () {
    var app = new Vue({
        el: '#app',
        data: {
        }
    });
};

Vue.component('channel_groups', {
    data: function () {
        return {
            items: []
        }
    },
    props: ['recurring'],

    template: '<div id="channelGroupList" >\
                    <div class="row">\
                        <div v-for="(item, index) in items" class="col-12 row-no-padding">\
                            <div v-bind:class="getClass(item)" id="device" class="small-item" @click="selectGroup(item.name)">\
                                <div class="row">\
                                    <div><span class="text-primary">{{ item.name }}</span></div>\
                                    <div v-if="deletable(item)" @click="deleteGroup(item)"  class="ml-auto float-md-right"><i class="fa fa-lg fa-trash text-secondary"></i>&nbsp;</div><br>\
                                </div>\
                            </div>\
                        </div>\
                    </div>\
                </div>',
    mounted: function () {
        var self = this;
        self.reloadGroups();
    },
    methods: {
        reloadGroups() {
            var self = this;
            var url = 'services/service?method=channel.groups';
            $.getJSON(url, function (data) {
                self.items = [];
                data.groups.forEach(function (groupName) {
                    var group = {
                        name: groupName,
                        selected: false
                    }
                    self.items.push(group);
                });
                self.selectGroup(self.items[0].name);
            });
        },
        getClass(item) {
            return {
                'small-item': true,
                'group-selected ': item.selected
            }
        },
        selectGroup(selectedItem) {
            var self = this;
            this.items.forEach(function (item) {
                if (item.name === selectedItem) {
                    item.selected = true;
                    OnSelectedGroup(selectedItem);
                } else {
                    item.selected = false;
                }
            });
        },
        deletable(item) {  
            if (item.name === "All Channels")
                return false;
            return true;
        },
        deleteGroup(item) {            
            var self = this;
            var url = 'services/service?method=channel.groups.remove';
            url += "&id=" + encodeURIComponent(item.name);
            $.getJSON(url, function (data) {
                self.reloadGroups();
            });        
        }
    }
});
