﻿window.onload = function () {
    var app = new Vue({
        el: '#app',
        data: {
        }
    });
};

Vue.component('auto_map_modal', {
    data: function () {
        return {
            listing: ""
        };
    },    
    template: '<div class="modal fade" id="autoMapModal" tabindex="-1" role="dialog" aria-labelledby="autoMapModalLabel" aria-hidden="true">\
                    <div class= "modal-dialog modal-lg" role="document" >\
                        <div class="modal-content">\
                            <div class="modal-header">\
                                <h5 class="modal-title">Auto Map EPG</h5>\
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">\
                                    <span aria-hidden="true">&times;</span>\
                                </button>\
                            </div>\
                            <div class="modal-body">\
                                <div class="form-inline">\
                                    <div class= "col-md-12 form-group">\
                                        <label for="name" class="col-sm-2 col-form-label">Channel Type:&nbsp;</label>\
                                        <select id="mappingChannelType" class="custom-select col-sm-10 form-control" data-container="body">\
                                            <option value="loading">...loading...</option>\
                                        </select>\
                                    </div>\
                                </div>\
                                <div class="form-inline">\
                                    <div class= "col-md-12 form-group">\
                                        <label for="name" class="col-sm-2 col-form-label">EPG Source:&nbsp;</label>\
                                        <select id="mappingEPGSource" class="custom-select col-sm-10 form-control" data-container="body">\
                                            <option value="loading">...loading...</option>\
                                        </select>\
                                    </div>\
                                </div>\
                                <div class="form-inline">\
                                    <div class= "col-md-12 form-group">\
                                        <label for="name" class="col-sm-2 col-form-label">Map Strategy:&nbsp;</label>\
                                        <select id="mappingStrategy" class="custom-select col-sm-10 form-control" data-container="body">\
                                            <option value="default">Numbers and Identifiers</option>\
                                            <option value="names">Channel Names</option>\
                                        </select>\
                                    </div>\
                                </div>\
                            </div>\
                            <div class="modal-footer">\
                                <button type="button" class="btn btn-primary" @click="autoMapChannels" data-dismiss="modal">Auto Map</button>\
                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>\
                            </div>\
                        </div>\
                    </div>\
               </div>',
    mounted: function () {
        var self = this;   
        self.loaded = false;
    },
    methods: {
        show() {              
            // load EPG sources            
            var url = 'services/service?method=setting.epg.sources';
            $.getJSON(url, function (sources) {
                var select = null;
                $('#mappingEPGSource').empty();
                for (var i = 0, len = sources.length; i < len; i++) {
                    var source = sources[i];
                    $('#mappingEPGSource').append("<option value='" + source.id + "'>" + source.name + "</option>");
                    if (select == null) {
                        select = source.id;
                    }
                }
                
                // add additionals...
                //$('#mappingEPGSource').append("<option value='addsd'>...Add Schedules Direct Lineup....</option>");
                //$('#mappingEPGSource').append("<option value='addxmltv'>...Add XMLTV Lineup....</option>");

                $('#mappingEPGSource').val(select).change();
            });

            // load channel types
            url = 'services/service?method=setting.channel.types';
            $.getJSON(url, function (sources) {
                var select = null;
                $('#mappingChannelType').empty();
                for (var i = 0, len = sources.length; i < len; i++) {
                    var source = sources[i];
                    $('#mappingChannelType').append("<option value='" + source + "'>" + source + "</option>");
                    if (select == null) {
                        select = source;
                    }
                }

                // add additionals...
                $('#mappingChannelType').val(select).change();
            });


            // show modal
            $('#autoMapModal').modal('show');            
        },
        autoMapChannels() {
            var url = 'services/service?method=setting.epg.automap&format=json';
            url += "&type=" + encodeURIComponent($('#mappingChannelType').val());
            url += "&source=" + encodeURIComponent($('#mappingEPGSource').val());
            url += "&prefer=" + encodeURIComponent($('#mappingStrategy').val());
            // do request
            $.ajax({
                url: url,
                headers: { "Content-Type": "text/plain" },
                crossDomain: true,
                type: 'get',
                async: true,
                success: function (response, textStatus, xhr) {
                    console.log("mapped source");
                    reloadChannels();
                },
                error: function (xhr, textStatus, errorThrown) {
                    console.log('automap error: ' + textStatus + ": " + errorThrown);
                }
            });
        }
    }
});
