﻿window.onload = function () {
    var app = new Vue({
        el: '#app',
        data: {
        }
    });
};

Vue.component('add_xmltv_lineup_modal', {
    data: function () {
        return {
            listing: ""
        };
    },    
    template: '<div class="modal fade" id="addXMLTVModal" tabindex="-1" role="dialog" aria-labelledby="detailsModalLabel" aria-hidden="true">\
                    <div class= "modal-dialog modal-lg" role="document" >\
                        <div class="modal-content">\
                            <div class="modal-header">\
                                <h5 class="modal-title">Add XMLTV Lineup</h5>\
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">\
                                    <span aria-hidden="true">&times;</span>\
                                </button>\
                            </div>\
                            <div class="modal-body">\
                                <div class="form-inline">\
                                    <div class= "col-md-12 form-group">\
                                        <label for="name" class="col-sm-2 col-form-label">URL / File:&nbsp;</label>\
                                        <input type="text" class="col-sm-10 form-control" id="xmltvFilename">&nbsp;\
                                    </div>\
                                </div>\
                            </div>\
                            <div class="modal-footer">\
                                <button id="addXMLTVLineup" type="button" class="btn btn-primary" @click="addSDLineup" data-dismiss="modal">Add Lineup</button>\
                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>\
                            </div>\
                        </div>\
                    </div>\
               </div>',
    mounted: function () {
        var self = this;   
        self.loaded = false;
    },
    methods: {
        show() {                                            
            $('#addXMLTVModal').modal('show');            
        },
        addSDLineup() {
            var url = 'services/service?method=setting.xmltv.addlineup&format=json';
            url += "&url=" + encodeURIComponent($('#xmltvFilename').val());
            // do request
            $.ajax({
                url: url,
                headers: { "Content-Type": "text/plain" },
                crossDomain: true,
                type: 'get',
                async: true,
                success: function (response, textStatus, xhr) {
                    console.log("added lineup");
                    reloadEPGSources();
                },
                error: function (xhr, textStatus, errorThrown) {
                    console.log('Error finding lineups: ' + textStatus + ": " + errorThrown);
                }
            });
        }
    }
});
