﻿window.onload = function () {
    var app = new Vue({
        el: '#app',
        data: {
        }
    });
};

Vue.component('add_sd_lineup_modal', {
    data: function () {
        return {
            listing: ""
        };
    },    
    template: '<div class="modal fade" id="addSDModal" tabindex="-1" role="dialog" aria-labelledby="detailsModalLabel" aria-hidden="true">\
                    <div class= "modal-dialog modal-lg" role="document" >\
                        <div class="modal-content">\
                            <div class="modal-header">\
                                <h5 class="modal-title">Add Schedules Direct Lineup</h5>\
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">\
                                    <span aria-hidden="true">&times;</span>\
                                </button>\
                            </div>\
                            <div class="modal-body">\
                                <div id="sdCredentials" class="row">\
                                    <div class= "col-lg-12 col-md-12 col-sm-12 col-xs-12">\
                                        <div class="form-inline">\
                                            <label for="name" class="col-lg-2 col-xs-4">Username:&nbsp;</label>\
                                            <input type="text" autocomplete="off" class="form-control" id="sdUsername">\
                                        </div>\
                                        <input name="DummyUsername" type="text" style="display:none;">\
                                        <input name="DummyPassword" type="password" style="display:none;">\
                                        <div class="form-inline">\
                                            <label for="name" class="col-lg-2 col-xs-4">Password:&nbsp;</label>\
                                            <input type="password" autocomplete="off" class="form-control" id="sdPassword">\
                                        </div>\
                                    </div>\
                                </div>\
                                <hr>\
                                <div class="row">\
                                    <div class= "col-lg-12 col-md-12 col-sm-12 col-xs-12">\
                                        <div class="form-inline">\
                                            <label for="name" class="col-lg-2 col-xs-4">ZipCode:&nbsp;</label>\
                                            <input type="text" class="form-control" id="sdPostCode" placeholder="zip code">&nbsp;\
                                            <select id="sdCountry" class="custom-select my-1 mr-sm-2" data-container="body">\
                                                <option value="loading">...loading...</option>\
                                            </select>\
                                            <button type="button" class="btn btn-secondary" @click="searchSDLineup">Search</button>\
                                        </div>\
                                    </div>\
                                </div>\
                                <hr>\
                                <div class="row">\
                                    <div class= "col-lg-12 col-md-12 col-sm-12 col-xs-12">\
                                        <div id="sdLineupFields" class="form-inline">\
                                            <label for="name" class="col-lg-2 col-xs-4">Lineup:&nbsp;</label>\
                                            <select id="sdLineup" class="custom-select my-1 mr-sm-2" data-container="body">\
                                            </select>\
                                        </div>\
                                    </div>\
                                </div>\
                            </div>\
                            <div class="modal-footer">\
                                <button id="addSDLineup" type="button" class="btn btn-primary" @click="addSDLineup" data-dismiss="modal">Add Lineup</button>\
                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>\
                            </div>\
                        </div>\
                    </div>\
               </div>',
    mounted: function () {
        var self = this;   
        self.loaded = false;

        $.ajax({
            url: 'services/service?method=setting.sd.regions&format=json',
            headers: { "Content-Type": "text/text" },
            crossDomain: true,
            type: 'get',
            async: true,
            success: function (response, textStatus, xhr) {
                console.log('got sd countries');
                $('#sdCountry').empty();

                if (response.hasOwnProperty("message")) {
                    if (window.eventBus != null) {
                        window.eventBus.$emit('schedulesDirecMessage', response.message);
                    }
                } else {
                    var regionArray = ["North America", "Europe", "ZZZ", "Latin America", "Caribbean"];
                    var arrayLength = regionArray.length;
                    for (var r = 0; r < arrayLength; r++) {
                        for (var i = 0, len = response[regionArray[r]].length; i < len; i++) {
                            var region = response[regionArray[r]][i];
                            $('#sdCountry').append("<option value='" + region.shortName + "'>" + regionArray[r] + " - " + region.fullName + "</option>");
                        }
                    }
                }
            },
            error: function (xhr, textStatus, errorThrown) {
                console.error('Error getting sd countries: ' + textStatus + ": " + errorThrown);
            }
        });

    },
    methods: {
        show(showCredentials) {         

            if (showCredentials == false) {
                $('#sdCredentials').hide();
            }

            $('#sdLineup').empty();
            $('#addSDLineup').hide();
            $('#sdLineupFields').hide();   
            
            // show modal
            $('#addSDModal').modal('show');            
        },
        searchSDLineup() {                
            // build up search parameters
            var url = 'services/service?method=setting.sd.findlineups&format=json';
            url += "&username=" + encodeURIComponent($('#sdUsername').val());
            url += "&password=" + encodeURIComponent($('#sdPassword').val());
            url += "&country=" + encodeURIComponent($('#sdCountry').val());
            url += "&postcode=" + encodeURIComponent($('#sdPostCode').val());

            $('#sdLineup').empty();
            $('#addSDLineup').hide();

            // do request
            $.ajax({
                url: url,
                headers: { "Content-Type": "text/plain" },
                crossDomain: true,
                type: 'get',
                async: true,
                success: function (response, textStatus, xhr) {
                    for (var i = 0, len = response.length; i < len; i++) {
                        var lineup = response[i];
                        $('#sdLineup').append("<option value='" + lineup.id + "'>" + lineup.name + "</option>");
                    }
                    if (response.length > 0) {
                        $('#addSDLineup').show();
                        $('#sdLineupFields').show();
                    }
                },
                error: function (xhr, textStatus, errorThrown) {
                    console.log('Error finding lineups: ' + textStatus + ": " + errorThrown);
                }
            });
        },
        addSDLineup() {
            var url = 'services/service?method=setting.sd.addlineup&format=json';
            url += "&id=" + encodeURIComponent($('#sdLineup').val());
            // do request
            $.ajax({
                url: url,
                headers: { "Content-Type": "text/plain" },
                crossDomain: true,
                type: 'get',
                async: true,
                success: function (response, textStatus, xhr) {
                    if (response.stat == "ok") {
                        console.log("added lineup");
                        reloadEPGSources();
                    }
                    else {
                        alert(response.message);
                    }
                },
                error: function (xhr, textStatus, errorThrown) {
                    console.log('Error finding lineups: ' + textStatus + ": " + errorThrown);
                }
            });
        }
    }
});
