﻿window.onload = function () {
    var app = new Vue({
        el: '#app',
        data: {
        }
    });
};

Vue.component('add_group_modal', {
    data: function () {
        return {
            listing: "",
            timer: 0
        };
    },
    template: '<div class="modal fade" id="addGroupModal" tabindex="-1" role="dialog" aria-labelledby="addGroupModalLabel" aria-hidden="true">\
                    <div class= "modal-dialog" role="document" >\
                        <div class="modal-content">\
                            <div class="modal-header">\
                                <h5 class="modal-title" id="messageModalTitle">Add Channel Group</h5>\
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">\
                                    <span aria-hidden="true">&times;</span>\
                                </button>\
                            </div>\
                            <div class="modal-body">\
                                <div class="form-inline">\
                                    <div class= "col-md-12 form-group">\
                                        <label for="groupName" class="col-sm-2 col-form-label">Group:&nbsp;</label>\
                                        <input type="text" class="col-sm-10 form-control" id="groupName">&nbsp;\
                                    </div>\
                                </div>\
                            </div>\
                            <div class= "modal-footer">\
                                <button type="button" class="btn btn-secondary" @click="addGroup" data-dismiss="modal">OK</button>\
                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>\
                            </div>\
                        </div>\
                    </div>\
               </div>',
    mounted: function () {
        var self = this;
        self.loaded = false;
    },
    methods: {
        show() {
            var self = this;
            $('#groupName').val('');
            $('#addGroupModal').modal('show');
        },
        addGroup() {
            var url = 'services/service?method=channel.groups.add';
            url += "&group=" + encodeURIComponent($('#groupName').val());
            // do request
            $.ajax({
                url: url,
                headers: { "Content-Type": "text/plain" },
                crossDomain: true,
                type: 'get',
                async: true,
                success: function (response, textStatus, xhr) {
                    console.log("added group");
                    reloadGroups();
                },
                error: function (xhr, textStatus, errorThrown) {
                    console.log('Error adding group: ' + textStatus + ": " + errorThrown);
                }
            });
        }
    }
});